/*
 * Decompiled with CFR 0.152.
 */
public class BlockConstants {
    private boolean is_always_legal = true;
    private boolean never_hides_adjacent_faces;
    private boolean uses_new_sand_physics;
    private boolean is_always_immutable = false;
    private boolean uses_alpha_blending;
    private Boolean connects_with_fence;

    public void validate(aqz block) {
        String msg = null;
        if (!(block instanceof aqp)) {
            if (this.uses_alpha_blending) {
                if (block.n() != 1) {
                    msg = block + " uses alpha blending but getRenderBlockPass()==" + block.n();
                }
            } else if (block.n() != 0) {
                msg = block + " does not use alpha blending but getRenderBlockPass()==" + block.n();
            }
        }
        if (msg == null) {
            return;
        }
        atv.setErrorMessage("validate: " + msg);
        new Exception().printStackTrace();
    }

    public BlockConstants setNotAlwaysLegal() {
        this.is_always_legal = false;
        return this;
    }

    public BlockConstants setAlwaysImmutable() {
        this.is_always_legal = true;
        this.is_always_immutable = true;
        return this;
    }

    public BlockConstants setUsesAlphaBlending() {
        this.uses_alpha_blending = true;
        return this.setNeverHidesAdjacentFaces();
    }

    public BlockConstants setNeverHidesAdjacentFaces() {
        this.connects_with_fence = false;
        this.never_hides_adjacent_faces = true;
        return this;
    }

    public BlockConstants setUseNewSandPhysics() {
        if (!atv.allow_new_sand_physics) {
            return this;
        }
        this.uses_new_sand_physics = true;
        this.is_always_legal = false;
        return this;
    }

    public BlockConstants setAlwaysConnectsWithFence() {
        this.connects_with_fence = true;
        return this;
    }

    public BlockConstants setNeverConnectsWithFence() {
        this.connects_with_fence = false;
        return this;
    }

    public boolean isAlwaysLegal() {
        return this.is_always_legal;
    }

    public boolean neverHidesAdjacentFaces() {
        return this.never_hides_adjacent_faces;
    }

    public boolean isAlwaysImmutable() {
        return this.is_always_immutable;
    }

    public boolean usesNewSandPhysics() {
        return this.uses_new_sand_physics;
    }

    public Boolean connectsWithFence() {
        return this.connects_with_fence;
    }
}

